' GetBaud returns the current baud rate in Baud$
' b% should be set to &h3f8 or &h2f8 for com1: and com2:, respectively.
'
' Barry Jaspan, 11/01/87

GetBaud:
 b%=&h3f8
 dlab%=inp(b%+3)
 dlab%=dlab% or 128
 out b%+3,dlab%    ' Set Divisor Latch Access Bit on
 lsb%=inp(b%)     ' read least significant byte of divisor
 msb%=inp(b%+1)   '  read most significant byte of divisor
 Divisor%=(msb%*255)+lsb%
 dlab%=dlab% and 127
 out b%+3,dlab%  ' Set Divisor Latch Access Bit off
 select case divisor%
  case 383
   baud$="300"
  case 96
   baud$="1200"
  case 48
   baud$="2400"
  case 24
   baud$="4800"
  case 12
   baud$="9600"
 end select
return
